<?php
/**
* Styler Quick View
*/
if ( ! defined( 'ABSPATH' ) ) exit; // If this file is called directly, abort.
if ( ! class_exists( 'Styler_QuickView' ) ) {
    class Styler_QuickView
    {
        private static $instance = null;

        function __construct()
        {
            // frontend scripts
            add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_scripts' ) );

            // shortcode
            add_shortcode( 'styler_quickview', array( $this, 'quick_view_shortcode' ) );

            // frontend template
            add_action( 'wp_ajax_styler_quickview', array( $this, 'quick_view_template' ) );
            add_action( 'wp_ajax_nopriv_styler_quickview', array( $this, 'quick_view_template' ) );

        }

        public function enqueue_scripts()
        {
            wp_enqueue_script( 'styler-quickview', STYLER_PLUGIN_URL . 'assets/front/js/quickview/quickview.js', array( 'jquery' ), STYLER_PLUGIN_VERSION, true );
        }

        public static function get_settings($opt='',$def='') {
            $option = get_option('styler');

            return isset($option[$opt]) ? $option[$opt] : $def;
        }

        public function quick_view_shortcode( $atts )
        {
            $output = '';

            $atts = shortcode_atts( array(
                'id'    => null,
                'title' => '',
                'icon'  =>''
            ), $atts, 'styler_quickview' );

            if ( ! $atts['id'] ) {
                global $product;
                $atts['id'] = $product->get_id();
            }

            $title = $atts['title'] ? esc_html($atts['title']) : esc_html__('Quick View', 'styler');
            $icon = $atts['icon'] ? $atts['icon'] : styler_svg_lists( 'eye', 'styler-svg-icon' );
            $html = '<div class="styler-quickview-btn styler-product-button" data-id="'.esc_attr( $atts['id'] ).'" data-label="'.$title.'">'.$icon.'</div>';

            return apply_filters( 'styler_quickview_html', $html, $atts['id'] );
        }

        public function quick_view_template()
        {
            global $post, $product;
            $product_id   = absint( $_GET['product_id'] );
            $catalog_mode = self::get_settings( 'woo_catalog_mode', '0' );
            $thumbs_type  = self::get_settings( 'quick_view_slider_thumbs_type', 'bottom' );
            $product      = wc_get_product( $product_id );

            if ( $product ) {
                $post = get_post( $product_id );
                setup_postdata( $post );

                $images = $product->get_gallery_image_ids();
                $size   = apply_filters( 'styler_quickview_product_thumb_size', 'large' );
                if ( post_password_required($post) ) {
                    ?>
                    <div class="styler-quickview-wrapper single-content zoom-anim-dialog product-protected">
                        <p><?php echo esc_html_e('This content is password protected.', 'styler'); ?></p>
                        <a class="styler-btn-medium styler-btn styler-bg-black" href="<?php echo esc_url( get_permalink( $product_id ) ) ?>"><?php echo esc_html_e('Check Product', 'styler'); ?></a>
                    </div>
                    <?php
                } else {
                    $class  = 'styler-quickview-wrapper single-content zoom-anim-dialog thumbs-'.$thumbs_type;
                    ?>
                    <div id="product-<?php echo $product_id; ?>" <?php wc_product_class( $class, $product ); ?>>
                        <div class="container-full styler-container-full">
                            <div class="row">
                                <div class="col-lg-7">
                                    <div class="styler-swiper-slider-wrapper">
                                        <div class="styler-quickview-main styler-swiper-main swiper">
                                            <?php styler_single_product_labels(); ?>
                                            <div class="swiper-wrapper styler-swiper-wrapper">
                                                <?php
                                                echo '<div class="swiper-slide">'.get_the_post_thumbnail( $product->get_id(), $size ).'</div>';
                                                foreach( $images as $image ) {
                                                    echo '<div class="swiper-slide"><img src="'.wp_get_attachment_image_url($image,'woocommerce_thumbnail').'" alt="'.esc_html( $product->get_name() ).'"/></div>';
                                                }
                                                ?>
                                            </div>
                                            <?php if ( is_rtl() ) { ?>
                                                <div class="swiper-button-next styler-swiper-next"></div>
                                                <div class="swiper-button-prev styler-swiper-prev"></div>
                                            <?php } else { ?>
                                                <div class="swiper-button-prev styler-swiper-prev"></div>
                                                <div class="swiper-button-next styler-swiper-next"></div>
                                            <?php } ?>
                                        </div>

                                        <div class="styler-quickview-thumbnails styler-swiper-thumbnails swiper">
                                            <div class="swiper-wrapper styler-swiper-wrapper"></div>
                                            <div class="nav-wrapper">
                                                <div class="swiper-button-prev styler-swiper-prev"></div>
                                                <div class="swiper-button-next styler-swiper-next"></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-5">
                                    <div class="styler-quickview-product-details styler-product-summary">
                                        <div class="styler-product-summary-inner">
                                            <?php
                                            the_title( '<h4 class="styler-product-title">', '</h4>' );

                                            if ( '1' != $catalog_mode ) {
                                                woocommerce_template_single_price();
                                            }
                                            if ( has_excerpt() ) { ?>
                                                <div class="styler-summary-item"><?php the_excerpt(); ?></div>
                                                <?php
                                            }
                                            if ( '1' != $catalog_mode ) {
                                                woocommerce_template_single_add_to_cart($product);
                                            }
                                            do_action('styler_quick_after_add_to_cart');
                                            ?>
                                            <div class="styler-summary-item"><?php woocommerce_template_single_meta(); ?></div>
                                            <div class="styler-quickview-notices"></div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                    <?php
                }
                wp_reset_postdata();
            }
            die();
        }

        public static function get_instance()
        {
            if ( is_null( self::$instance ) ) {
                self::$instance = new self;
            }
            return self::$instance;
        }
    }
    Styler_QuickView::get_instance();
}
